<!doctype html><html><head><meta charset="utf-8"><title>Big Calendar</title>
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6/main.min.css" rel="stylesheet"/>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6/main.min.js"></script>
<link rel="stylesheet" href="../assets/css/style.css">
</head><body>
<h2>Big Calendar</h2>
<div id="calendar"></div>

<!-- Modal -->
<div id="eventModal" style="display:none; position:fixed; left:50%; top:20%; transform:translateX(-50%); background:#fff; padding:20px; border:1px solid #ccc; z-index:9999; max-width:600px;">
  <div id="modalContent"></div>
  <button onclick="document.getElementById('eventModal').style.display='none'">Close</button>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  var calendarEl = document.getElementById('calendar');
  var calendar = new FullCalendar.Calendar(calendarEl, {
    initialView: 'dayGridMonth',
    headerToolbar: { left: 'prev,next today', center: 'title', right: '' },
    events: '/events/api/get_events.php',
    eventClick: function(info) {
      fetch('/events/api/get_event.php?id=' + info.event.id)
        .then(r=>r.json()).then(data=>{
          if(data.success){
            var e = data.event;
            var html = '<h3>'+e.name+'</h3><p>'+e.date+' '+(e.stime?e.stime:'')+' - '+(e.etime?e.etime:'')+'</p><p>'+ (e.place?e.place:'') +'</p><div>'+ (e.content?e.content:'') +'</div>';
            document.getElementById('modalContent').innerHTML = html;
            document.getElementById('eventModal').style.display = 'block';
          } else alert('Event not found');
        });
    }
  });
  calendar.render();
});
</script>
</body></html>
