<?php
// reset_admin.php - use this to create or reset an admin user in 3ce_users table.
// IMPORTANT: After running this file once, DELETE it from the server for security.
require_once __DIR__ . '/config/db.php';

// Change these values if you prefer
$username = 'admin';
$new_password = 'Admin@1234';
$email = 'admin@example.com';

$hash = password_hash($new_password, PASSWORD_DEFAULT);

try {
    // Try updating existing user
    $stmt = $pdo->prepare('UPDATE `3ce_users` SET password = ?, status = 1 WHERE username = ?');
    $stmt->execute([$hash, $username]);
    if ($stmt->rowCount() > 0) {
        echo "Password updated for user: {$username}\n";
        echo "Login with username: {$username} and password: {$new_password}\n";
        exit;
    }

    // If no existing user, insert a new one. Adjust column names if your table differs.
    $stmt2 = $pdo->prepare('INSERT INTO `3ce_users` (username, password, email, joindate, status, autoapprove) VALUES (?, ?, ?, ?, 1, 1)');
    $stmt2->execute([$username, $hash, $email, date('Y-m-d')]);
    echo "New admin user created: {$username}\n";
    echo "Login with username: {$username} and password: {$new_password}\n";
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
