<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../config/db.php';

$start = $_GET['start'] ?? null;
$end   = $_GET['end'] ?? null;

if ($start && $end) {
    $stmt = $pdo->prepare('SELECT id, name, date, stime, etime, place FROM 3ce_event WHERE date BETWEEN ? AND ? AND status=1');
    $stmt->execute([$start, $end]);
} else {
    $stmt = $pdo->query('SELECT id, name, date, stime, etime, place FROM 3ce_event WHERE status=1');
}
$rows = $stmt->fetchAll();

$events = [];
foreach ($rows as $r) {
    $events[] = [
        'id' => (int)$r['id'],
        'title' => $r['name'],
        'start' => $r['date'],
        'allDay' => true,
        'extendedProps' => [
            'stime' => $r['stime'],
            'etime' => $r['etime'],
            'place' => $r['place']
        ]
    ];
}
echo json_encode($events);
