<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require_once __DIR__ . '/../config/db.php';

$name = $_POST['name'] ?? '';
$place = $_POST['place'] ?? '';
$date = $_POST['date'] ?? null;
$stime = $_POST['stime'] ?? null;
$etime = $_POST['etime'] ?? null;
$repeat_year = isset($_POST['repeat_year']) ? 1 : 0;
$map = isset($_POST['map']) ? 1 : 0;
$content = $_POST['content'] ?? '';
$status = intval($_POST['status'] ?? 1);

// handle file upload
$iconFilename = null;
if (!empty($_FILES['icon']) && $_FILES['icon']['error'] === UPLOAD_ERR_OK) {
    $tmp = $_FILES['icon']['tmp_name'];
    $orig = basename($_FILES['icon']['name']);
    $safe = preg_replace('/[^A-Za-z0-9._-]/', '_', $orig);
    $target = __DIR__ . '/../uploads/events/' . $safe;
    if (move_uploaded_file($tmp, $target)) {
        $iconFilename = 'uploads/events/' . $safe;
    }
}

$stmt = $pdo->prepare('INSERT INTO events (name, icon, icon_only, content, place, date, stime, etime, repeat_year, status, map, id_user)
                       VALUES (?, ?, 0, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
$userId = 0;
$stmt->execute([$name, $iconFilename, $content, $place, $date, $stime, $etime, $repeat_year, $status, $map, $userId]);

header('Location: list_events.php');
exit;
